/*
  This code will batch resolve a number of ORDs in one go with 
  a minimal number of network calls.
*/

var ords = [
  "station:|slot:/BajaScriptTutorials/Ramp",
  "station:|slot:/BajaScriptTutorials/NumericWritable", 
  "station:|slot:/BajaScriptTutorials/Counter", 
  "station:|slot:/BajaScriptTutorials/Maps", 
  "station:|slot:/BajaScriptTutorials/EventTest", 
];

var resolve = new baja.BatchResolve(ords);

resolve.resolve({
  each: function () {
    baja.outln(this.getNavOrd());
  },
  fail: function (err) {
    baja.error(err);
  }
});
